function solver_hingemiddle = solver_hingemiddle(y)

global a_1 b_1 c_1 d_1 e_1 f_1 g_1 h_1 a_2 b_2 c_2 d_2 e_2 f_2 g_2 h_2 ds_1 ds_2 NP_1 NP_2 s_1 s_2 Restraint_1 Restraint_2 R_s_1 R_s_2 dR_s_1 dR_s_2 d2R_s_1 d2R_s_2 d3R_s_1 d3R_s_2 d4R_s_1 d4R_s_2 s_1_exp s_2_exp...
    d1_1 e1_1 f1_1 g1_1 c2_1 d2_1 e2_1 f2_1 g2_1 b3_1 c3_1 d3_1 e3_1 f3_1 g3_1...
    d1_2 e1_2 f1_2 g1_2 c2_2 d2_2 e2_2 f2_2 g2_2 b3_2 c3_2 d3_2 e3_2 f3_2 g3_2...
    Pn_1 Pn_2 m_load_1 m_load_2  Material_E J_1 J_2 dJ_1 dJ_2 d2J_1 d2J_2 k_el k_el_1 AL...
    aM_1 bM_1 cM_1 dM_1 aM_2 bM_2 cM_2 dM_2 aM_3 bM_3 cM_3 dM_3...
    aT_1 bT_1 cT_1 dT_1 eT_1 aT_2 bT_2 cT_2 dT_2 eT_2 aT_3 bT_3 cT_3 dT_3 eT_3...
    aN_1 bN_1 cN_1 dN_1 eN_1 fN_1 aN_2 bN_2 cN_2 dN_2 eN_2 fN_2 aN_3 bN_3 cN_3 dN_3 eN_3 fN_3...

HP = NP_1+6;

k_el = (2.1*10^8*J_1(NP_1)/(0.5*AL));
% k_el_1 = (2.1*10^8*J_1(1)/(0.5*AL));
% k_el_1 = (2.1*10^8*J_1(2)/x_s_1(2))*0.1;

%% Definition equation for finite difference

% Inner points:  %derivate dello spostamento espresse rispetto allo
% spostamento stesso
for i=4:NP_1+3
    y1(i) = ((-1/60)*y(i-3) + (3/20)*y(i-2) + (-3/4)*y(i-1) + (0)*y(i) + (3/4)*y(i+1) + (-3/20)*y(i+2) + (1/60)*y(i+3))/ds_1;
    y2(i) = ((1/90)*y(i-3) + (-3/20)*y(i-2) + (3/2)*y(i-1) + (-49/18)*y(i) + (3/2)*y(i+1) + (-3/20)*y(i+2) + (1/90)*y(i+3))/(ds_1^2);
    y3(i) = ((1/8)*y(i-3) + (-1)*y(i-2) + (13/8)*y(i-1) + (0)*y(i) + (-13/8)*y(i+1) + (1)*y(i+2) + (-1/8)*y(i+3))/(ds_1^3);
    y4(i) = ((-1/6)*y(i-3) + (2)*y(i-2) + (-13/2)*y(i-1) + (28/3)*y(i) + (-13/2)*y(i+1) + (2)*y(i+2) + (-1/6)*y(i+3))/(ds_1^4);
    y5(i) = ((-1/2)*y(i-3) + (2)*y(i-2) + (-5/2)*y(i-1) + (0)*y(i) + (5/2)*y(i+1) + (-2)*y(i+2) + (1/2)*y(i+3))/(ds_1^5);
    y6(i) = ((1)*y(i-3) + (-6)*y(i-2) + (15)*y(i-1) + (-20)*y(i) + (15)*y(i+1) + (-6)*y(i+2) + (1)*y(i+3))/(ds_1^6);
end
    y1 = [y1 zeros(1,6)];
    y2 = [y2 zeros(1,6)];
    y3 = [y3 zeros(1,6)];
    y4 = [y4 zeros(1,6)];
    y5 = [y5 zeros(1,6)];
    y6 = [y6 zeros(1,6)];

for i=4:NP_2+3
    y1(i+HP) = ((-1/60)*y(i+HP-3) + (3/20)*y(i+HP-2) + (-3/4)*y(i+HP-1) + (0)*y(i+HP) + (3/4)*y(i+HP+1) + (-3/20)*y(i+HP+2) + (1/60)*y(i+HP+3))/ds_2;
    y2(i+HP) = ((1/90)*y(i+HP-3) + (-3/20)*y(i+HP-2) + (3/2)*y(i+HP-1) + (-49/18)*y(i+HP) + (3/2)*y(i+HP+1) + (-3/20)*y(i+HP+2) + (1/90)*y(i+HP+3))/(ds_2^2);
    y3(i+HP) = ((1/8)*y(i+HP-3) + (-1)*y(i+HP-2) + (13/8)*y(i+HP-1) + (0)*y(i+HP) + (-13/8)*y(i+HP+1) + (1)*y(i+HP+2) + (-1/8)*y(i+HP+3))/(ds_2^3);
    y4(i+HP) = ((-1/6)*y(i+HP-3) + (2)*y(i+HP-2) + (-13/2)*y(i+HP-1) + (28/3)*y(i+HP) + (-13/2)*y(i+HP+1) + (2)*y(i+HP+2) + (-1/6)*y(i+HP+3))/(ds_2^4);
    y5(i+HP) = ((-1/2)*y(i+HP-3) + (2)*y(i+HP-2) + (-5/2)*y(i+HP-1) + (0)*y(i+HP) + (5/2)*y(i+HP+1) + (-2)*y(i+HP+2) + (1/2)*y(i+HP+3))/(ds_2^5);
    y6(i+HP) = ((1)*y(i+HP-3) + (-6)*y(i+HP-2) + (15)*y(i+HP-1) + (-20)*y(i+HP) + (15)*y(i+HP+1) + (-6)*y(i+HP+2) + (1)*y(i+HP+3))/(ds_2^6);
end

    y1 = [y1 zeros(1,3)];
    y2 = [y2 zeros(1,3)];
    y3 = [y3 zeros(1,3)];
    y4 = [y4 zeros(1,3)];
    y5 = [y5 zeros(1,3)];
    y6 = [y6 zeros(1,3)];


%% Definition of restraints

% if Restraint_1 == 1
%     bc_left_1 = y(4);
%     bc_left_2 = y1(4);
%     bc_left_3 = y2(4);              % Left
% elseif Restraint_1 == 2
%     bc_left_1 = y(4);
%     bc_left_2 = y1(4);
%     bc_left_3 = -R_s_1(1).*y3(4) - (2.*dR_s_1(1).*y2(4)) - ((d2R_s_1(1)+(1./R_s_1(1))).*y1(4)) + ((dR_s_1(1)./(R_s_1(1).^2)).*y(4)); % Left
% end
% 
% 
% if Restraint_2 == 1
%     bc_right_1 = y2(NP_2+HP+3);
%     bc_right_2 = y1(NP_2+HP+3);
%     bc_right_3 = y(NP_2+HP+3);     % Right
% elseif Restraint_2 == 2
%     bc_right_1 = -(R_s_2(NP_2).*y3(NP_2+HP+3) - 2.*dR_s_2(NP_2).*y2(NP_2+HP+3) - (d2R_s_2(NP_2)+(1./R_s_2(NP_2))).*y1(NP_2+HP+3) + (dR_s_2(NP_2)./(R_s_2(NP_2).^2)).*y(NP_2+HP+3));
%     bc_right_2 = y1(NP_2+HP+3);
%     bc_right_3 = y(NP_2+HP+3); % Right
% 
% end

 %% Cerniera elastica in chiave arco incastrato
 
    bc_left_1 = y(4);
    bc_left_2 = y1(4);
    bc_left_3 = y2(4);

    bc_right_1 = y2(NP_2+HP+3);
    bc_right_2 = y1(NP_2+HP+3);
    bc_right_3 = y(NP_2+HP+3); 

%% Caso di cerniera alle basi

%         bc_left_1 = y(4);
%         bc_left_2 = y1(4);
%        
%         bc_right_2 = y1(NP_2+HP+3);
%         bc_right_1 = y(NP_2+HP+3);
%% Cerniera totale alle basi
% bc_left_1 = y(4);
% bc_left_2 = y1(4);
% bc_left_3 = (Material_E.*J_1(1).*(aM_1(1).*y3(4) + bM_1(1).*y2(4) + cM_1(1).*y1(4) + dM_1(1).*y(4)));
% 
% bc_right_1 = (Material_E.*J_2(NP_2).*(aM_2(NP_2).*y3(NP_2+HP+3) + bM_2(NP_2).*y2(NP_2+HP+3) + cM_2(NP_2).*y1(NP_2+HP+3) + dM_2(NP_2).*y(NP_2+HP+3)));
% bc_right_2 = y1(NP_2+HP+3);
% bc_right_3 = y(NP_2+HP+3); % Right
%% Boundary conditions for hinge

Equal_u = y(NP_1+3) - y(HP+4);
Equal_v = -y1(NP_1+3)*R_s_1(NP_1) + y1(HP+4)*R_s_2(1);

%% Cerniera elastica in chiave 

M_elhinge_1 = (Material_E.*J_1(NP_1).*(aM_1(NP_1).*y3(NP_1+3) + bM_1(NP_1).*y2(NP_1+3) + cM_1(NP_1).*y1(NP_1+3) + dM_1(NP_1).*y(NP_1+3)))-...
    ((y2(HP+4).*R_s_2(1) + y1(HP+4).*dR_s_2(1) + y(HP+4).*R_s_2(1))-...
    (y2(NP_1+3).*R_s_1(NP_1) + y1(NP_1+3).*dR_s_1(NP_1) + y(NP_1+3).*R_s_1(NP_1))).*k_el;

M_elhinge_2 = -(Material_E.*J_2(1).*(aM_2(1).*y3(HP+4) + bM_2(1).*y2(HP+4) + cM_2(1).*y1(HP+4) + dM_2(1).*y(HP+4)))+...
    ((y2(HP+4).*R_s_2(1) + y1(HP+4).*dR_s_2(1) + y(HP+4).*R_s_2(1))-...
    (y2(HP-3).*R_s_1(NP_1) + y1(HP-3).*dR_s_1(NP_1) + y(HP-3).*R_s_1(NP_1))).*k_el;

%% Cerniere elastiche alle basi 

M_elhinge_sx = (Material_E.*J_1(1).*(aM_1(1).*y3(4) + bM_1(1).*y2(4) + cM_1(1).*y1(4) + dM_1(1).*y(4)))-...
    (y2(4).*R_s_1(1) + y1(4).*dR_s_1(1) + y(4).*R_s_1(1)).*k_el_1;

M_elhinge_dx = -(Material_E.*J_2(NP_2).*(aM_2(NP_2).*y3(HP+NP_2+3) + bM_2(NP_2).*y2(HP+NP_2+3) + cM_2(NP_2).*y1(HP+NP_2+3) + dM_2(NP_2).*y(HP+NP_2+3)))-...
    (y2(HP+NP_2+3).*R_s_2(NP_2) + y1(HP+NP_2+3).*dR_s_2(NP_2) + y(HP+NP_2+3).*R_s_2(NP_2)).*k_el_1;



%% Cerniera totale in chiave 

%  M_1 = (Material_E.*J_1(NP_1).*(aM_1(NP_1).*y3(NP_1+3) + bM_1(NP_1).*y2(NP_1+3) + cM_1(NP_1).*y1(NP_1+3) + dM_1(NP_1).*y(NP_1+3)));
%  M_2 = (Material_E.*J_2(1).*(aM_2(1).*y3(HP+4) + bM_2(1).*y2(HP+4) + cM_2(1).*y1(HP+4) + dM_2(1).*y(HP+4)));
 %% Condizioni al contorno per T ed N 

T_1 = -Material_E.*(aT_1(NP_1).*y4(NP_1+3) + bT_1(NP_1).*y3(NP_1+3) + cT_1(NP_1).*y2(NP_1+3) + dT_1(NP_1).*y1(NP_1+3) + eT_1(NP_1).*y(NP_1+3));
T_2 = -Material_E.*(aT_2(1).*y4(HP+4) + bT_2(1).*y3(HP+4) + cT_2(1).*y2(HP+4) + dT_2(1).*y1(HP+4) + eT_2(1).*y(HP+4));

Equal_T = T_1 - T_2;

N_1 = R_s_1(NP_1).*Pn_1(NP_1) - R_s_1(NP_1).*Material_E.*(aN_1(NP_1).*y5(NP_1+3) + bN_1(NP_1).*y4(NP_1+3) + cN_1(NP_1).*y3(NP_1+3) + dN_1(NP_1).*y2(NP_1+3) + eN_1(NP_1).*y1(NP_1+3) + fN_1(NP_1).*y(NP_1+3));
N_2 = R_s_2(1).*Pn_2(1) - R_s_2(1).*Material_E.*(aN_2(1).*y5(HP+4) + bN_2(1).*y4(HP+4) + cN_2(1).*y3(HP+4) + dN_2(1).*y2(HP+4) + eN_2(1).*y1(HP+4) + fN_2(1).*y(HP+4));

Equal_N = N_1 - N_2;

%% Equations to solve

 equ_1 = a_1(1:NP_1).*y6(4:NP_1+3)+b_1(1:NP_1).*y5(4:NP_1+3)+c_1(1:NP_1).*y4(4:NP_1+3)+d_1(1:NP_1).*y3(4:NP_1+3)+e_1(1:NP_1).*y2(4:NP_1+3)+f_1(1:NP_1).*y1(4:NP_1+3)+g_1(1:NP_1).*y(4:NP_1+3)+h_1(1:NP_1);
 equ_2 = a_2(1:NP_2).*y6(4+HP:NP_2+3+HP)+b_2(1:NP_2).*y5(4+HP:NP_2+3+HP)+c_2(1:NP_2).*y4(4+HP:NP_2+3+HP)+d_2(1:NP_2).*y3(4+HP:NP_2+3+HP)+e_2(1:NP_2).*y2(4+HP:NP_2+3+HP)+f_2(1:NP_2).*y1(4+HP:NP_2+3+HP)+g_2(1:NP_2).*y(4+HP:NP_2+3+HP)+h_2(1:NP_2);
 
%% Solver per cerniera elastica in chiave 
  solver_hingemiddle= [equ_1 equ_2 bc_left_1 bc_left_2 bc_left_3 bc_right_1 bc_right_2 bc_right_3 Equal_u Equal_v M_elhinge_1 M_elhinge_2 Equal_T Equal_N];
%% Solver per cerniera totale in chiave 
% solver_hingemiddle= [equ_1 equ_2 bc_left_1 bc_left_2 bc_left_3 bc_right_1 bc_right_2 bc_right_3 Equal_u Equal_v M_1 M_2 Equal_T Equal_N];

%% Solver cerniera totale in chiave ed elastica alle basi

%  solver_hingemiddle= [equ_1 equ_2 bc_left_1 bc_left_2 bc_right_1 bc_right_2 Equal_u Equal_v M_1 M_2 Equal_T Equal_N M_elhinge_sx M_elhinge_dx];
%% Solver cerniera elastica in chiave ed elastica alle basi

%  solver_hingemiddle= [equ_1 equ_2 bc_left_1 bc_left_2 bc_right_1 bc_right_2 Equal_u Equal_v M_elhinge_1 M_elhinge_2 Equal_T Equal_N M_elhinge_sx M_elhinge_dx];